
#import "@preview/vlna:0.1.0":*
#show: apply-vlna

#let translate-citation(doc) = [
#let var_1 = regex("vid.")
#show var_1: it => text()[cit.]
#doc
]

#set page(
    paper: "a4",
    margin: (
        left: 2.5cm,
        right: 2.5cm,
        top: 3cm,
        bottom: 3cm
    ),
)
#set text(12pt, lang: "cs", hyphenate: false)

#set par(justify: true)

#align(center)[
    == DELTA – Střední škola informatiky a ekonomie, s.r.o.
    == Ke Kamenci 151, Pardubice
]

#align(center + horizon)[
    #text(25pt)[
        = Vyhledávač spojení
    ]
]


#align(left + bottom)[
    == Adam Jedlička
    == 4.A
    == Informační technologie (18-20-m/01)
    ==
    == 2024/2025
]

#pagebreak()

=

#pagebreak()

Prohlašuji, že jsem maturitní projekt vypracoval samostatně, výhradně s použitím uvedené literatury.
=

#align(left)[V Pardubicích 31. 3. 2025]

#align(right)[(vlastnoruční podpis)]

#pagebreak()

= Poděkování
Upřímně děkuji doc. Mgr. Josefu Horálkovi, Ph.D. za odborné vedení při
zpracovávání maturitního projektu.

#pagebreak()

= Resumé
Tento projekt se zaměřuje na vývoj webové aplikace pro plánování tras veřejnou dopravou s využitím otevřených dat a moderních technologií. Aplikace umožňuje uživatelům zadat start a cíl cesty ve formě GPS souřadnic, adres nebo názvů zastávek, a nabízí přizpůsobení parametrů, jako je čas na přestup, maximální počet přestupů nebo délka chůze. Backend aplikace je postavena v jazyce Rust s využitím frameworku Actix, zatímco frontend je implementován v TypeScriptu s knihovnou Leaflet.js pro zobrazení mapy. Pro vyhledávání adres a zastávek se používá Meilisearch, zatímco plánování tras zajišťuje OpenTripPlanner.

= Klíčová slova
Plánování tras, Jízdní řády, OpenTripPlanner, OpenStreetMap, Meilisearch, Nominatim, REST API, Leaflet.js, JDF, GTFS, Rust

= Anotation
This project focuses on developing a web application for public transport route planning using open data and modern technologies. The application allows users to input the start and destination of their journey as GPS coordinates, addresses, or stop names, and offers customization options such as transfer time, maximum number of transfers, or walking distance. The backend is built in Rust using the Actix framework, while the frontend is implemented in TypeScript with the Leaflet.js library to display the map. Meilisearch is used for searching addresses and stops, while route planning is handled by OpenTripPlanner.

= Keywords
Route planning, Timetables, OpenTripPlanner, OpenStreetMap, Meilisearch, Nominatim, REST API, Leaflet.js, JDF, GTFS, Rust

#pagebreak()

#set heading(numbering: "1.")
#outline(title: [Obsah], target: heading.where( numbering: "1."))


#set page(numbering: "1")

#pagebreak()

= Úvod

Hlavním cílem projektu je navrhnout a implementovat systém, který je nejen uživatelsky přívětivý, ale také technologicky flexibilní a snadno rozšiřitelný. Důraz je kladen na využití otevřených datových standardů, jako jsou jízdní řády ve formátu JDF dostupné přes CIS JŘ (Celostátní informační systém jízdních řádů), data GTFS poskytovaná některými dopravci (např. PID nebo IDS JMK) a mapové podklady OpenStreetMap. Architektura systému je navržena jednoduše a efektivně. Frontend je implementován v jazyce TypeScript s využitím mapové knihovny Leaflet.js, backend pak v jazyce Rust s frameworkem Actix. Tento přístup zajišťuje snadnou integraci dalších funkcí a technologií v budoucnu.
Existující řešení (např. IDOS, Jízdní řády Seznam.cz (Pubtran.cz), Arriva, České dráhy, DPMP, Mapy Google či CG Transit) mají určitá omezení například omezenou podporu zadávání GPS souřadnic, nedostatečné možnosti přizpůsobení parametrů cesty. Dalším problémem existujících řešení je skutečnost, že nedokážou některé trasy najít vůbec například kvůli způsobu vyhledávání, neúplným nebo nekonzistentním datům. Tato práce se snaží tato omezení překonat pomocí otevřených datových zdrojů a pečlivého zpracování jízdních řádů.

#pagebreak()

= Existující řešení

Na českém trhu existuje několik aplikací pro plánování tras veřejnou dopravou:

- *IDOS*: Jedna z nejrozšířenějších českých aplikací pro vyhledávání spojení. Umožňuje zadání startu a cíle pomocí názvů zastávek nebo adres, má hodně možností přizpůsobení ale nepodporuje zadávání GPS souřadnic. Data jízdních řádů pochází od společnosti CHAPS.

- *CG Transit*: Mobilní aplikace s podporou offline režimu pro vyhledávání spojení v České republice i na Slovensku. Nabízí intuitivní rozhraní a podporu více typů dopravy. Zdarma jde použít pouze na měsíc. @Blazek282011 @Blazekcca2010 @Riha952011

- *Jízdní řády Seznam.cz (Pubtran.cz)*: Dopravní aplikace od Seznam.cz nabízející přehledné vyhledávání spojení veřejné dopravy s přímou integrací do Mapy.cz. Poskytuje uživatelsky přívětivé rozhraní pro plánování cest po České republice.

- *Mapy Google*: Řešení pro plánování tras různými dopravními prostředky. Nabízí základní funkce pro navigaci a v některých oblastech i informace o zpoždění. Významným nedostatkem je však absence mnoha lokálních jízdních řádů, což omezuje jeho použitelnost pro plánování cest veřejnou dopravou v ČR.

- *Aplikace jednotlivých dopravců*: České dráhy (Můj vlak), DPMP (DPMP Online), PID Lítačka či Arriva nabízejí vlastní specializovaná řešení zaměřená na konkrétní regiony nebo typy dopravy.

I přes širokou nabídku existujících aplikací se stále objevují problémy:
- Omezená nebo žádná podpora GPS souřadnic (např. IDOS) nebo adres (např. DPMP).
- Nedostatečné možnosti detailního nastavení parametrů cesty.

Při testování jsem zjistil, že někdy existující aplikace nejsou schopny nalézt určité specifické trasy či kombinace spojení, které moje webová aplikace dokáže najít.

Tento projekt se snaží uvedená omezení překonat využitím otevřených dat (OpenStreetMap, GTFS, JDF) pro doplnění chybějících poloh zastávek do dat CIS JŘ a kombinací datových formátů JDF a GTFS od různých dopravců.

#pagebreak()

= Použité technologie

Pro vývoj webové aplikace byly použity následující technologie:

== Frontend
- *TypeScript*: Jazyk rozšiřující JavaScript o statické typování.
- *Leaflet.js*: Knihovna pro interaktivní mapy.
- *HTML/CSS*: Technologie pro strukturování obsahu a stylování uživatelského rozhraní.

== Backend
- *Rust*: Programovací jazyk oceňovaný pro svou rychlost, efektivitu a bezpečnost při práci s pamětí.
- *Actix*: Framework pro rychlou implementaci REST API v Rustu.

== Vyhledávání adres a zastávek
- *Meilisearch*: Fulltextový vyhledávač použitý k rychlému vyhledávání adres, zastávek a nádraží.

== Mapové podklady a geokódování
- *OpenStreetMap*: Otevřený zdroj mapových dat použitý k výběru polohy na mapě a získání chybějících poloh zastávek.
- *Overpass API*: Rozhraní umožňující dotazovat data z OSM.
- *Nominatim*: Geokódovací služba převádějící adresy na GPS souřadnice a opačně a vyhledávač OpenStreetMap.

== Zpracování jízdních řádů
- *jrutil*: Nástroj umožňující parsovat jízdní řády ve formátu JDF používaném v CIS JŘ a jejich konverzi do mezinárodního standardu GTFS používaného nástrojem OpenTripPlanner. @Konarik482018

== Plánování tras
OpenTripPlanner: Open-source nástroj pro plánování tras veřejnou dopravou, pěšky nebo na kole.

#pagebreak()
= Architektura
#figure(
    image("maturitní projekt - vyhledávač spojení_.png"),
    caption: [
        Architektura
    ]
) <obrazek_2>

#pagebreak()

= Teoretická část
V této části je zmapován současný stav problematiky plánování tras veřejnou dopravou, popsány klíčové pojmy a technologie použité při návrhu aplikace, a zdůvodněn výběr jednotlivých nástrojů.

== Současný stav problematiky

Plánování tras veřejnou dopravou je důležitou součástí moderní mobility, zejména v městských oblastech. Existuje řada aplikací, které tuto funkci poskytují, například IDOS, Mapy Google nebo Jízdní řády Seznam.cz (Pubtran.cz). Tyto nástroje však někdy čelí omezením, jako je absence podpory GPS souřadnic, nedostatečné možnosti přizpůsobení parametrů cesty nebo uzavřenost datových formátů.

Další problém představuje dostupnost dat. V České republice jsou jízdní řády spravovány společností CHAPS ve formátu JDF, který je určen pro strojové zpracování ale chybí polohy zastávek, CHAPS má data o polohách zastávek ale nejsou veřejně přístupné. Přístup k těmto datům byl historicky omezený, což vedlo k právním sporům o jejich otevřenost. Alternativně lze využít otevřené datové zdroje, jako jsou data JDF a GTFS od jednotlivých dopravců a zkombinovat je s  mapovými podklady OpenStreetMap, které nabízejí flexibilitu a široké možnosti využití. @0O2J8KV87Zo4Hrbb @tqxI6Fw1HSJ2eNPW @Futera2024 @k7Wqb0325r3SLWlc @43auevpuXAASjnZV

== Klíčové pojmy
*JDF (Jednotný datový formát)*:
Formát používaný v České republice pro jízdní řády veřejné dopravy, založený na CSV struktuře. Obsahuje informace o spojích, zastávkách a časech. JDF je spravován v rámci CIS JŘ ale chybí GPS souřadnice zastávek, které je nutné doplnit z jiných zdrojů, například z OpenStreetMap.

*CIS JŘ (Celostátní informační systém o jízdních řádech)*:
Centrální systém spravovaný společností CHAPS, který integruje jízdní řády veřejné dopravy v ČR. Obsahuje schválené jízdní řády pro vnitrostátní i mezinárodní linkovou dopravu, železniční dopravu na celostátní i regionální úrovni a registr zastávek, linek a dopravců. Data jsou poskytována zpravidla ve formátu JDF, CZPTT, NeTEx. @DXaVfXlFBdu7fJJO @PAl0kNmgQYwN5Wgj @uO9QA619hz2ztaML

*GTFS (General Transit Feed Specification)*:
Globální standard pro data veřejné dopravy, vytvořený společností Google. GTFS umožňuje publikovat data o zastávkách, trasách, spojích a časech ve formě textových souborů (.txt) v formátu CSV zabalených do ZIP archivu. Používají jej dopravci jako PID nebo IDS JMK a je široce podporován nástroji pro plánování tras, jako je třeba OpenTripPlanner. @wUBbGOG7Iidmq4uX @eDlSBoFIYEidJ3xT @CTmppWYeR6FSD1JD


*NeTEx (Network Timetable Exchange)*:
Evropský standard pro výměnu dat veřejné dopravy založený na XML. Pokrývá širokou škálu informací, od topologie sítě přes jízdní řády až po tarifní informace. Netex je modulární a umožňuje výměnu komplexních dat mezi různými systémy. Kvůli jeho složitosti a nekompatibilitě různých profilů nebyl v projektu použit. @ynHpbHOzlDGkxbsJ @GAJkqG1V4YOTu8vN @67r8KdN6CjZh9DV2

*OpenStreetMap (OSM)*:
Otevřený projekt poskytující mapová data. V projektu slouží k doplnění chybějících poloh zastávek z CIS JŘ. Data z OSM jsou získávána pomocí Overpass API a Geofabrik. @n8JkInavBH4oivfo


*Leaflet.js*:
Knihovna pro práci s interaktivními mapami na webu. Používána k výběru GPS souřadnic.

*OpenTripPlanner*:
Open-source nástroj pro plánování tras veřejnou dopravou, pěšky nebo na kole. Podporuje formáty GTFS, NeTEx a OpenStreetMap. V projektu využívá data ve formátu GTFS a OpenStreetMap, která jsou generována z JDF pomocí nástroje jrutil. @B5ZMe7W3IcA1mnpJ

== Omezení projektu
Projekt nepoužívá formát Netex kvůli jeho složitosti a nekompatibilitě různých profilů. Dále nepracuje s aktuální polohou vozidel ani nevyužívá uživatelské účty, data jsou ukládána lokálně v Local Storage bez nutnosti registrace. Poloha některých zastávek chybí nebo není přesná protože v OpenStreetMap chybí nebo mají jiný název nebo nemají žádný název.

Tato teoretická část poskytuje přehled o současném stavu problematiky a použitých technologiích, což tvoří základ pro návrh architektury systému v další části práce.
#pagebreak()



== Vlastní řešení

=== Návrh architektury systému
- Frontend: TypeScript, Leaflet.js
- Backend: Rust s Actix frameworkem
- Vyhledávání: Meilisearch
- Plánování tras: OpenTripPlanner
Na @obrazek_2 je vidět detailnější architektura a Use case diagram je na @obrazek_5

=== Zpracování dat jízdních řádů
- Parsování jízdních řádů (JDF) pomocí jrutil
- Konverze do GTFS formátu pro použití v OpenTripPlanneru pomocí jrutil
- Doplnění chybějících poloh zastávek v datech CIS JŘ pomocí OpenStreetMap
- Deduplikace dat a odstranění neplatných nebo zastaralých záznamů

Na @obrazek_7 níže je vidět aplikace ve světlém motivu

#figure(
    image("obrazek_1.png", width: 70%),
    caption: [
        Vyhledávač spojení světlý motiv
    ]

) <obrazek_7>

#pagebreak()
=== Vyhledávání adres a zastávek pomocí Meilisearch
Pro zajištění rychlého a účinného vyhledávání zadávaných adres a zastávek je využit fulltextový vyhledávač Meilisearch. Systém pracuje s daty získanými z otevřených zdrojů, například z OpenStreetMap, a také relevantní informace extrahované z jízdních řádů. Díky tomu může uživatel při zadávání dotazu získat okamžité návrhy, které odpovídají hledaným výrazům, a tím zjednodušit a urychlit proces plánování cesty. Jak je vidět na @obrazek_6.

#figure(
    image("obrazek_2.png", width: 70%),
    caption: [
        Vyhledávání adresy školy
    ]
) <obrazek_6>

=== UML Use Case diagram
#figure(
image("vyhledávač_spojení_use_case_diagram.drawio.png", width: 80%),
    caption: [
        Use case diagram
    ]
) <obrazek_5>

#pagebreak()

== Výsledky
Výsledná aplikace nabízí širokou škálu funkcionalit, které byly úspěšně implementovány. Uživatelé mohou plánovat trasy veřejnou dopravou s využitím různých vstupů, jako jsou GPS souřadnice, adresy nebo názvy zastávek. Aplikace umožňuje nastavení parametrů cesty, jako je minimální čas na přestup, maximální počet přestupů nebo délka chůze.

Ukázka plánování trasy zahrnuje příklad spojení, které nebyly nalezeny existujícími aplikacemi, jako je IDOS nebo Mapy Google. Díky pečlivému zpracování dat (JDF a GTFS) a doplnění chybějících poloh zastávek z OpenStreetMap a způsobu vyhledávání OpenTripPlanner dokáže aplikace najít trasy, které by jinak nebyly dostupné.

=== Porovnání s DPMP
z: Šípková 370, 53352 Staré Hradiště

do: Kpt.Nálepky

datum: 31.3.2025

čas: 11:20

Jak vyplývá z @obrazek_3 tak moje aplikace zobrazuje spojení s příjezdem už okolo 12 hodin ale DPMP na @obrazek_4 až v 13 hodin.

#figure(
image("obrazek_3.png", width: 65%),
    caption: [
        Výsledek vyhledávání
    ]
) <obrazek_3>
#figure(
image("obrazek_4.png"),
    caption: [
        Výsledek vyhledávání DPMP
    ]
) <obrazek_4>


== Diskuse
=== Zdůvodnění zvoleného řešení a technologií
Použité technologie byly zvoleny s ohledem na výkon, flexibilitu a otevřenost dat. Rust byl vybrán pro backend kvůli své bezpečnosti a rychlosti, zatímco TypeScript umožňuje vývoj frontendové části. Leaflet.js se ukázal jako ideální nástroj pro zvolení polohy na mapě díky své jednoduchosti a podpoře OpenStreetMap. Vyhledávání adres a zastávek pomocí Meilisearch poskytuje rychlé a přesné výsledky.

=== Porovnání vytvořené aplikace s existujícími řešeními
V porovnání s existujícími aplikacemi, jako jsou třeba IDOS nebo Mapy Google, nabízí moje řešení větší flexibilitu při zadávání vstupů (např. GPS souřadnice) a detailnější možnosti konfigurace parametrů cesty. Navíc dokáže najít některé specifické trasy, které konkurenční nástroje nejsou schopny identifikovat kvůli způsobu vyhledávání, omezeným nebo neúplným datům.

=== Zhodnocení náročnosti doplňování chybějících poloh zastávek.
Doplnění chybějících poloh zastávek v datech CIS JŘ bylo jedním z technicky nejnáročnějších úkolů projektu. Použití dat z OpenStreetMap vyžadovalo důkladnou validaci a kontrolu přesnosti, aby byly výsledné polohy zastávek použitelné. Tento proces přinesl možnost plánování tras v datech JDF.

=== Možnosti dalšího rozšíření
Diskutované možnosti rozšíření zahrnují vizualizaci tras na mapě. Další potenciál spočívá v rozšíření analytických funkcí systému, například predikce vytížení spojů nebo personalizace výsledků vyhledávání podle preferencí uživatele.

#pagebreak()

== Závěr
=== Celkové shrnutí dosažených výsledků
Projekt splnil stanovené cíle vytvořená aplikace je funkční, uživatelsky přívětivá a technologicky flexibilní. Díky využití otevřených datových zdrojů (JDF, GTFS, OpenStreetMap) a OpenTripPlanner se podařilo v některých aspektech překonat omezení existujících řešení.

=== Zhodnocení úspěšnosti realizace projektu
Aplikace byla úspěšně implementována s využitím moderních technologií (Rust, TypeScript, Leaflet.js) a otevřených datových standardů. Výsledný systém je robustní a připravený na další rozvoj.

=== Návrhy na další vývoj aplikace
Budoucí rozvoj by mohl zahrnovat integraci aktuálních poloh vozidel pro zobrazení zpoždění v reálném čase, rozšíření funkcí pro analýzu jízdních dat nebo optimalizaci vyhledávacího systému za účelem ještě rychlejšího poskytování výsledků.

#pagebreak()

#show: translate-citation
#bibliography("bibliografie.bib", style: "iso690-numeric-brackets-cs.csl", title: "Literatura")

#pagebreak()

#outline(title: "Seznam obrázků", target: figure.where(kind: image))
