use std::{borrow::Cow, hint::black_box};

#[must_use] pub fn original_coordinate(input: &str) -> String {
    input
        .trim()
        .to_uppercase()
        .replace('D', "°")
        .replace(':', " ")
        .replace(['[', ']'], "")
        .replace(';', ",")
}
pub fn original_coordinate_(input: Vec<&str>) {
    for i in input {
        let _ = original_coordinate(black_box(i));
    }
}

#[must_use] pub fn optimize_coordinate(input: &str) -> Cow<str> {
    let result: Cow<str> = input.trim().to_uppercase().into();

    if result.contains(['D', ':', '[', ']', ';']) {
        let mut s = String::with_capacity(result.len());
        for c in result.chars() {
            match c {
                'D' => s.push('°'),
                ':' => s.push(' '),
                '[' | ']' => {}
                ';' => s.push(','),
                _ => s.push(c),
            }
        }
        Cow::Owned(s)
    } else {
        result
    }
}
pub fn optimize_coordinate_(input: Vec<&str>) {
    for i in input {
        let _ = optimize_coordinate(black_box(i));
    }
}

#[must_use] pub fn optimize_coordinate_2(input: &str) -> Cow<str> {
    // let mut modified = false;
    let result: Cow<str> = input.trim().to_uppercase().into();
    // if result.contains(&['D', ':', '[', ']', ';'])
    // {
    // modified = true;
    let mut s = String::with_capacity(result.len());
    for c in result.chars() {
        match c {
            'D' => s.push('°'),
            ':' => s.push(' '),
            '[' | ']' => {}
            ';' => s.push(','),
            _ => s.push(c),
        }
    }
    Cow::Owned(s)
}
pub fn optimize_coordinate_2_(input: Vec<&str>) {
    for i in input {
        let _ = optimize_coordinate_2(black_box(i));
    }
}

#[must_use] pub fn optimize_coordinate_3(input: &str) -> String {
    let result = input.trim().to_uppercase();

    if result.contains(['D', ':', '[', ']', ';']) {
        let mut s = String::with_capacity(result.len());
        for c in result.chars() {
            match c {
                'D' => s.push('°'),
                ':' => s.push(' '),
                '[' | ']' => {}
                ';' => s.push(','),
                _ => s.push(c),
            }
        }
        s
    } else {
        result
    }
}
pub fn optimize_coordinate_3_(input: Vec<&str>) {
    for i in input {
        let _ = optimize_coordinate_3(black_box(i));
    }
}

// https://en.wikiversity.org/wiki/Geographic_coordinate_conversion
pub const COORDINATES: [&str; 17] = [
    "402646302N 0795855903W",
    "402646302N0795855903W",
    "40:26:46.302N 079:58:55.903W",
    "40°26′46″N 079°58′56″W",
    "40d 26′ 46\" N 079d 58' 56\" W",
    "40.446195N 79.982195W",
    "40.446195, -79.982195",
    "40.446195 -79.982195",
    "40.446195,-79.982195",
    "40° 26.7717, -79° 58.93172",
    "N40:26:46.302 W079:58:55.903",
    "n40:26:46.302 w079:58:55.903",
    "N40°26′46\" W079°58′56\"",
    "N40d 26' 46\" W079d 58' 56\"",
    "N40.446195 W79.982195",
    "[40.446195;-79.982195]",
    "   [40.446195; -79.982195]         ",
];

#[cfg(test)]
mod tests_ {
    use super::*;

    #[test]
    fn test_parse_coordinate_() {

        for coordinate in COORDINATES {
            assert_eq!(
                original_coordinate(coordinate),
                optimize_coordinate(coordinate)
            );
        }
    }
}
