use std::time::Duration;

use criterion::{black_box, criterion_group, criterion_main, Criterion};
use vyhledavac_spojeni_api::{optimize_coordinate_, optimize_coordinate_3_, COORDINATES};


fn benchmark(c: &mut Criterion) {
    let mut group = c.benchmark_group("MyBenchmark");
    group.measurement_time(Duration::from_secs(80));

    // group.bench_function("original", |b| {
    //     b.iter(|| original_coordinate_(black_box(COORDINATES.repeat(1))))
    // });
    group.bench_function("optimized", |b| {
        b.iter(|| optimize_coordinate_(black_box(COORDINATES.into())));
    });
    // group.bench_function("optimized2", |b| {
    //     b.iter(|| optimize_coordinate_2_(black_box(COORDINATES.repeat(1))))
    // });
    group.bench_function("optimized3", |b| {
        b.iter(|| optimize_coordinate_3_(black_box(COORDINATES.into())));
    });
}

criterion_group!(benches, benchmark);
criterion_main!(benches);
