#!/bin/sh

cd ~ || exit

if [ ! -f $(date -d "@$(($(date -d $(date +%Y-%m-01) +%s) - 12 * 3600))" +%Y%m%d)_OB_ADR_csv.zip ]; then
    rm -rf CSV *_OB_ADR_csv.zip addresses.csv
    wget https://vdp.cuzk.cz/vymenny_format/csv/$(date -d "@$(($(date -d $(date +%Y-%m-01) +%s) - 12 * 3600))" +%Y%m%d)_OB_ADR_csv.zip
    unzip *_OB_ADR_csv.zip
fi

download_with_fallback() {
    primary_url="https://overpass-api.de/api/interpreter"
    fallback_url="https://overpass.private.coffee/api/interpreter"
    post_data="$1"
    output_file="$2"

    if wget --post-data="$post_data" "$primary_url" -O "$output_file"; then
        echo "Success with primary URL: $primary_url"
        return 0
    fi

    echo "Primary URL failed, trying fallback: $fallback_url"
    if wget --post-data="$post_data" "$fallback_url" -O "$output_file"; then
        echo "Success with fallback URL: $fallback_url"
        return 0
    fi

    echo "Both URLs failed"
    exit 1
}

if [ ! -f bus_tram_stops.json ]; then
    post_data=$(
        cat <<'EOL'
[out:json][timeout:50][maxsize:40Mi];
area["name:en"="Czechia"]["admin_level"="2"]->.searchArea;
(
  node["highway"="bus_stop"](area.searchArea);
  node["railway"="tram_stop"](area.searchArea);
);
out geom;
EOL
    )
    download_with_fallback "$post_data" bus_tram_stops.json
fi

if [ ! -f railway_stations.json ]; then
    post_data=$(
        cat <<'EOL'
[out:json][timeout:30][maxsize:3Mi];
area["name:en"="Czechia"]["admin_level"="2"]->.searchArea;
(
  node["railway"="station"](area.searchArea);
  node["railway"="halt"](area.searchArea);
);
out geom;
EOL
    )
    download_with_fallback "$post_data" railway_stations.json
fi

if [ ! -f city_town_suburb_village.json ]; then
    post_data=$(
        cat <<'EOL'
[out:json][timeout:100][maxsize:8Mi];
area["name:en"="Czechia"]["admin_level"="2"]->.searchArea;
(
  node["place"="city"](area.searchArea);
  node["place"="town"](area.searchArea);
  node["place"="suburb"](area.searchArea);
  node["place"="village"](area.searchArea);
);
out geom;
EOL
    )
    download_with_fallback "$post_data" city_town_suburb_village.json
fi

if [ ! -f addresses.csv ]; then
    parse-czech-republic-cuzk-addresses CSV >addresses.csv
    meilisearch addresses.csv "${MEILI_MASTER_KEY}"
fi

sleep infinity
