#[derive(Serialize, Deserialize)]
struct Document {
    id: i64,
    name: String,
    r#type: String,
    _geo: String,
}

use core::time;
use meilisearch_sdk::client::*;
use serde::{Deserialize, Serialize};
use serde_json::Value;
use std::env;
use std::io::BufReader;
use std::{fs::File, io::prelude::*, thread::sleep};

#[tokio::main(flavor = "current_thread")]
async fn main() {
    const INDEX_NAME: &str = "search";

    let args: Vec<String> = env::args().collect();
    println!("{args:#?}");
    let client = Client::new(
        "http://vyhledavac_spojeni-meilisearch-1:7700",
        Some(args[2].clone()),
    )
    .unwrap();

    let mut file = File::open(args[1].clone()).unwrap();

    let mut content: Vec<Document> = Vec::new();

    let mut file_content = String::new();
    file.read_to_string(&mut file_content).unwrap();
    let mut rdr = csv::ReaderBuilder::new()
        .has_headers(false)
        .delimiter(b';')
        .from_reader(file_content.as_bytes());
    for (index, result) in rdr.records().enumerate() {
        let record = result.unwrap();

        content.push(Document {
            id: index as i64,
            name: record[0].to_owned(),
            r#type: "a".to_owned(), // a = address
            _geo: record[1].to_owned() + "," + &record[2],
        });
    }

    let file = File::open("bus_tram_stops.json").unwrap();
    let reader = BufReader::new(file);
    let value: Value = serde_json::from_reader(reader).unwrap();
    let mut number_of_nodes_without_name_or_official_name = 0;

    if let Some(numbers) = value["elements"].as_array() {
        for (index, record) in numbers.iter().enumerate() {
            let name = match &record["tags"]["name"] {
                Value::String(v) => v,
                _ => {
                    match &record["tags"]["official_name"] {
                        Value::String(v) => v,
                        _ => {
                            number_of_nodes_without_name_or_official_name += 1;
                            continue;
                        }
                    }
                }
            };
            content.push(Document {
                id: 10_000_000 + index as i64,
                name: name.to_string(),
                r#type: "b".to_owned(), // b = bus/tram stops
                _geo: record["lat"].to_string() + "," + &record["lon"].to_string(),
            });
        }
    }
    println!("number of bus tram stops that were excluded because they don't have name or official_name: {number_of_nodes_without_name_or_official_name}");

    let file = File::open("railway_stations.json").unwrap();
    let reader = BufReader::new(file);
    let value: Value = serde_json::from_reader(reader).unwrap();
    let mut number_of_nodes_without_name_or_official_name = 0;

    if let Some(numbers) = value["elements"].as_array() {
        for (index, record) in numbers.iter().enumerate() {
            let name = match &record["tags"]["name"] {
                Value::String(v) => v,
                _ => {
                    match &record["tags"]["official_name"] {
                        Value::String(v) => v,
                        _ => {
                            // println!("{:#?} {} {:#?}", record["tags"]["name"], index, record);
                            number_of_nodes_without_name_or_official_name += 1;
                            continue;
                        }
                    }
                }
            };
            content.push(Document {
                id: 20_000_000 + index as i64,
                name: name.to_owned(),
                r#type: "t".to_owned(), // t = train railway stations
                _geo: record["lat"].to_string() + "," + &record["lon"].to_string(),
            });
        }
    }
    println!("number of train railway stations that were excluded because they don't have name or official_name: {number_of_nodes_without_name_or_official_name}");

    let file = File::open("city_town_suburb_village.json").unwrap();
    let reader = BufReader::new(file);
    let value: Value = serde_json::from_reader(reader).unwrap();
    let mut number_of_nodes_without_name_or_official_name = 0;

    if let Some(numbers) = value["elements"].as_array() {
        for (index, record) in numbers.iter().enumerate() {
            let name = match &record["tags"]["name"] {
                Value::String(v) => v,
                _ => {
                    match &record["tags"]["official_name"] {
                        Value::String(v) => v,
                        _ => {
                            // println!("{:#?} {} {:#?}", record["tags"]["name"], index, record);
                            number_of_nodes_without_name_or_official_name += 1;
                            continue;
                        }
                    }
                }
            };
            content.push(Document {
                id: 30_000_000 + index as i64,
                name: name.to_owned(),
                r#type: "c".to_owned(), // c = city, town, suburb, village
                _geo: record["lat"].to_string() + "," + &record["lon"].to_string(),
            });
        }
    }
    println!("number of train cities towns suburbs villages that were excluded because they don't have name or official_name: {number_of_nodes_without_name_or_official_name}");

    let abc = client
        .index(INDEX_NAME)
        .add_documents(&content, Some("id"))
        .await
        .unwrap();
    println!("{abc:#?}");

    loop {
        sleep(time::Duration::from_millis(4000));

        let abc2 = client.get_task(&abc).await.unwrap();
        if abc2.is_success() {
            println!("{abc2:#?}");
            break;
        }
    }

    let searchable_attributes = ["name"];

    let task = client
        .index(INDEX_NAME)
        .set_searchable_attributes(&searchable_attributes)
        .await
        .unwrap();

    loop {
        sleep(time::Duration::from_millis(2000));

        let abc2 = client.get_task(&task).await.unwrap();
        if abc2.is_success() {
            println!("{abc2:#?}");
            break;
        }
    }

    println!("adding addresses to meilisearch is completed");
}
