import autocomplete from "autocompleter";

for (const element of Array.from(document.querySelectorAll<HTMLInputElement>("#from, #to"))) {
    autocomplete_(element);
}

function autocomplete_(input: HTMLInputElement) {
    autocomplete({
        input: input,
        fetch: async (text, update) => {
            const response = await fetch(
                `https://vyhledavac-spojeni.mooo.com/ms/indexes/search/search?q=${encodeURIComponent(text)}&attributesToRetrieve=name%2C_geo%2Ctype&offset=0&limit=6`,
                {
                    headers: {
                        Authorization:
                            "Bearer cba8729f035868957754ec00cfd989db5f40cc0de11ffeab20b6aea87e9a2da3",
                    },
                },
            );
            if (!response.ok) {
                throw new Error(`Response status: ${response.status}`);
            }

            const json = await response.json();
            update(
                json.hits.map((x: { name: string; type: string; _geo: string }) => ({
                    label: x.name,
                    value: x._geo,
                })),
            );
        },
        onSelect: (item) => {
            input.value = item.label ?? "";
            input.dataset.gps = item.value;
        },
        render: (item, value) => {
            const itemElement = document.createElement("div");
            if (value === "") {
                itemElement.innerHTML = item.label ?? "";
            } else {
                const regex = new RegExp(value, "gi");
                itemElement.innerHTML =
                    item.label?.replace(regex, (match) => `<strong>${match}</strong>`) ?? "";
            }
            return itemElement;
        },
        minLength: 0,
        showOnFocus: true,
        preventSubmit: 1,
    });
}
