#!/bin/sh
set -e

# shellcheck disable=SC2317
shutdown() {
    echo "Received SIGINT or SIGTERM"

    pkill -TERM 'certbot|crond'
    # https://nginx.org/en/docs/beginners_guide.html
    # https://nginx.org/en/docs/control.html
    pkill -QUIT nginx

    exit 0
}

trap shutdown INT TERM

# shellcheck disable=SC2153
sed "s/\$DOMAIN/${DOMAIN}/g; s/\$ALTERNATIVE_DOMAINS/$(echo "$ALTERNATIVE_DOMAINS" | tr ',' ' ')/g" /etc/nginx/nginx.conf.template >/etc/nginx/nginx.conf

if [ ! -d /etc/letsencrypt/live/"${DOMAIN}" ]; then
    if [ "$DOMAIN" = "localhost" ]; then
        mkdir -p /etc/letsencrypt/live/localhost
        # https://letsencrypt.org/docs/certificates-for-localhost
        # shellcheck disable=SC3001
        openssl req -x509 -out /etc/letsencrypt/live/localhost/fullchain.pem -keyout /etc/letsencrypt/live/localhost/privkey.pem \
            -newkey rsa:4096 -nodes -sha256 \
            -subj '/CN=localhost' -extensions EXT -config <( \
            printf "[dn]\nCN=localhost\n[req]\ndistinguished_name = dn\n[EXT]\nsubjectAltName=DNS:localhost,DNS:localhost.localhost,IP:127.0.0.1,IP:::1\nkeyUsage=digitalSignature\nextendedKeyUsage=serverAuth")
    else
        DOMAIN_=""

        if [ "$ALTERNATIVE_DOMAINS" = "localhost" ] || [ "$ALTERNATIVE_DOMAINS" = "localhost.localhost" ]; then
            # shellcheck disable=SC2153
            DOMAIN_=$DOMAIN
        else
            DOMAIN_=$DOMAIN,$ALTERNATIVE_DOMAINS
        fi

        mkdir -p /var/www/certbot
        nginx -c /etc/nginx/nginx-cert.conf
        certbot certonly --webroot -w /var/www/certbot --non-interactive --agree-tos --email "$EMAIL_FOR_LETS_ENCRYPT" -d "$DOMAIN_"
        pkill -QUIT nginx
    fi
fi

# https://letsencrypt.org/docs/faq/#why-should-my-let-s-encrypt-acme-client-run-at-a-random-time
# https://community.letsencrypt.org/t/new-service-busy-responses-beginning-during-high-load/184174
# https://certbot.eff.org/instructions?ws=nginx&os=pip
# shellcheck disable=SC2016
echo '0 0,12 * * * sleep $(python -c "import random; print(random.random() * 7200)") ; certbot renew --webroot -w /var/www/certbot --deploy-hook "pkill -HUP nginx"' | crontab -

crond -b
nginx -g 'daemon off;' &

wait
