#!/usr/bin/env bash

rm -rf stops.osm stops.osm.pbf updated_stops.osm updated_stops.osm.pbf first_filtered.osm.pbf second_all_ids.txt final.osm.pbf

osmium tags-filter czech-republic-latest.osm.pbf /public_transport /amenity=bus_station -o stops.osm.pbf

osmium cat stops.osm.pbf -o stops.osm

uv run add_bus_stop.py

osmium cat updated_stops.osm -o updated_stops.osm.pbf

osmium cat updated_stops.osm.pbf -f opl | grep -E '^(n|w|r)' | cut -d' ' -f1 > second_all_ids.txt

osmium removeid czech-republic-latest.osm.pbf -i second_all_ids.txt -o first_filtered.osm.pbf

osmium merge first_filtered.osm.pbf updated_stops.osm.pbf -o final.osm.pbf

rm -rf stops.osm stops.osm.pbf updated_stops.osm updated_stops.osm.pbf first_filtered.osm.pbf second_all_ids.txt
