import xml.etree.ElementTree as ET
import json
import re

with open("public_transport.json", "r") as file:
    data = json.load(file)

# Load the extracted OSM file
tree = ET.parse("stops.osm")
root = tree.getroot()

print(f"elements length: {len(data['elements'])}")

data["elements"] = [
    x
    for x in data["elements"]
    if not (
        len(re.sub(r"\(.*?\)", "", x["tags"]["name"]).strip()) <= 2
        or re.match(
            r"^[^[:space:]]{1,2}$", re.sub(r"\(.*?\)", "", x["tags"]["name"]).strip()
        )
        or re.match(
            r"^[[:digit:]]{1,3}$", re.sub(r"\(.*?\)", "", x["tags"]["name"]).strip()
        )
        or re.match(
            r"^[[:alpha:]][[:digit:]]{1,2}$",
            re.sub(r"\(.*?\)", "", x["tags"]["name"]).strip(),
        )
    )
]

a = 0
b = 0

for node in root.findall("./node") + root.findall("./way") + root.findall("./relation"):
    tags = {tag.get("k"): tag.get("v") for tag in node.findall("tag")}

    if (
        "public_transport" in tags
        and tags.get("bus") == "yes"
        and "name" in tags
        or tags.get("public_transport") == "station"
        or tags.get("amenity") == "bus_station"
    ):
        # if "highway" in tags:
        #     # assert tags.get("highway") == "bus_stop"
        #     b += 1
        #     continue
        a += 1
    else:
        b += 1
        continue

    isFound = False
    foundIndex = -1
    for index, element in enumerate(data["elements"]):
        if element["id"] == int(node.get("id")):
            isFound = True
            foundIndex = index
            break

    if isFound:
        data["elements"].pop(foundIndex)
        print(f"test {tags.get("name")}")
    else:
        continue

    if "highway" not in tags:  # Avoid duplicate tag
        print(tags.get("name"))
        new_tag = ET.Element("tag")
        new_tag.set("k", "highway")
        new_tag.set("v", "bus_stop")
        node.append(new_tag)

print(f"{a} {b}")
assert len(data["elements"]) == 0, (
    f"abc: {len(data['elements'])}\n abcd: {data['elements']}"
)

# Save the updated OSM file
tree.write("updated_stops.osm", encoding="utf-8", xml_declaration=True)
print("✅ Tags updated! Saved as 'updated_stops.osm'")
